/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import java.util.List;
import java.util.UUID;
import mekanism.api.security.IBlockSecurityUtils;
import mekanism.api.security.SecurityMode;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.security.SecurityFrequency;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class TileComponentSecurity
implements ITileComponent {
    public final TileEntityMekanism tile;
    private UUID ownerUUID;
    private String ownerName;
    private SecurityMode securityMode = SecurityMode.PUBLIC;

    public TileComponentSecurity(TileEntityMekanism tile) {
        this.tile = tile;
        tile.addComponent(this);
        tile.getFrequencyComponent().track(FrequencyType.SECURITY, true, false, true);
    }

    public SecurityFrequency getFrequency() {
        return (SecurityFrequency)this.tile.getFrequency(FrequencyType.SECURITY);
    }

    @ComputerMethod
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID uuid) {
        this.ownerUUID = uuid;
        if (this.ownerUUID == null) {
            this.tile.getFrequencyComponent().unsetFrequency(FrequencyType.SECURITY);
        } else {
            this.tile.setFrequency(FrequencyType.SECURITY, new Frequency.FrequencyIdentity(this.ownerUUID, SecurityMode.PUBLIC, this.ownerUUID), this.ownerUUID);
        }
    }

    @ComputerMethod
    public String getOwnerName() {
        return this.ownerName;
    }

    public SecurityMode getMode() {
        return this.securityMode;
    }

    public void setMode(SecurityMode mode) {
        if (this.securityMode != mode) {
            SecurityMode old = this.securityMode;
            this.securityMode = mode;
            this.tile.onSecurityChanged(old, this.securityMode);
            if (!this.tile.isRemote()) {
                this.tile.markForSave();
            }
        }
    }

    @Override
    public String getComponentKey() {
        return "component_security";
    }

    @Override
    public void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        this.securityMode = (SecurityMode)input.getOrDefault(MekanismDataComponents.SECURITY, (Object)this.securityMode);
        this.setOwnerUUID((UUID)input.getOrDefault(MekanismDataComponents.OWNER, (Object)this.ownerUUID));
    }

    @Override
    public void addRemapEntries(List<DataComponentType<?>> remapEntries) {
        if (this.ownerUUID == null) {
            remapEntries.add((DataComponentType)MekanismDataComponents.OWNER.get());
        }
    }

    @Override
    public void collectImplicitComponents(DataComponentMap.Builder builder) {
        builder.set(MekanismDataComponents.SECURITY, (Object)this.securityMode);
        if (this.ownerUUID != null) {
            builder.set(MekanismDataComponents.OWNER, (Object)this.ownerUUID);
        }
    }

    @Override
    public void deserialize(CompoundTag securityNBT, HolderLookup.Provider provider) {
        NBTUtils.setEnumIfPresent(securityNBT, "security_mode", SecurityMode.BY_ID, mode -> {
            this.securityMode = mode;
        });
        NBTUtils.setUUIDIfPresent(securityNBT, "owner", uuid -> {
            this.ownerUUID = uuid;
        });
    }

    @Override
    public CompoundTag serialize(HolderLookup.Provider provider) {
        CompoundTag securityNBT = new CompoundTag();
        if (this.securityMode != SecurityMode.PUBLIC) {
            NBTUtils.writeEnum(securityNBT, "security_mode", this.securityMode);
        }
        if (this.ownerUUID != null) {
            securityNBT.putUUID("owner", this.ownerUUID);
        }
        return securityNBT;
    }

    @Override
    public void trackForMainContainer(MekanismContainer container) {
        container.track(SyncableEnum.create(SecurityMode.BY_ID, SecurityMode.PUBLIC, this::getMode, this::setMode));
    }

    @Override
    public void addToUpdateTag(CompoundTag updateTag) {
        if (this.ownerUUID != null) {
            updateTag.putUUID("owner", this.ownerUUID);
            updateTag.putString("owner_name", MekanismUtils.getLastKnownUsername(this.ownerUUID));
        }
    }

    @Override
    public void readFromUpdateTag(CompoundTag updateTag) {
        NBTUtils.setUUIDIfPresent(updateTag, "owner", uuid -> {
            this.ownerUUID = uuid;
        });
        NBTUtils.setStringIfPresent(updateTag, "owner_name", name -> {
            this.ownerName = name;
        });
    }

    @ComputerMethod(nameOverride="getSecurityMode")
    SecurityMode getComputerSecurityMode() {
        if (this.tile.getLevel() == null) {
            return this.getMode();
        }
        return IBlockSecurityUtils.INSTANCE.getSecurityMode(this.tile.getLevel(), this.tile.getBlockPos(), this.tile);
    }
}

