/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.text.EnumColor;
import mekanism.common.attachments.component.AttachedEjector;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.IMultiTypeCapability;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.energy.BlockEnergyCapabilityCache;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.lib.inventory.HandlerTransitRequest;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.base.CapabilityTileEntity;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.EnergySlotInfo;
import mekanism.common.tile.component.config.slot.FluidSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.util.CableUtils;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.FluidUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.TransporterUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileComponentEjector
implements ITileComponent,
MekanismContainer.ISpecificContainerTracker {
    private final TileEntityMekanism tile;
    private final Map<TransmissionType, ConfigInfo> configInfo = new EnumMap<TransmissionType, ConfigInfo>(TransmissionType.class);
    private final Map<TransmissionType, Map<Direction, BlockCapabilityCache<?, @Nullable Direction>>> capabilityCaches = new EnumMap(TransmissionType.class);
    private final Map<Direction, BlockEnergyCapabilityCache> energyCapabilityCache = new EnumMap<Direction, BlockEnergyCapabilityCache>(Direction.class);
    private final Function<LogisticalTransporterBase, EnumColor> outputColorFunction;
    private final EnumColor[] inputColors = new EnumColor[EnumUtils.SIDES.length];
    private final LongSupplier chemicalEjectRate;
    private final IntSupplier fluidEjectRate;
    @Nullable
    private final LongSupplier energyEjectRate;
    @Nullable
    private Predicate<TransmissionType> canEject;
    @Nullable
    private Predicate<IChemicalTank> canTankEject;
    private boolean strictInput;
    private EnumColor outputColor;
    private int tickDelay = 0;

    public TileComponentEjector(TileEntityMekanism tile) {
        this(tile, MekanismConfig.general.chemicalAutoEjectRate);
    }

    public TileComponentEjector(TileEntityMekanism tile, LongSupplier chemicalEjectRate) {
        this(tile, chemicalEjectRate, MekanismConfig.general.fluidAutoEjectRate);
    }

    public TileComponentEjector(TileEntityMekanism tile, LongSupplier chemicalEjectRate, IntSupplier fluidEjectRate) {
        this(tile, chemicalEjectRate, fluidEjectRate, null);
    }

    public TileComponentEjector(TileEntityMekanism tile, LongSupplier energyEjectRate, boolean energyMarker) {
        this(tile, MekanismConfig.general.chemicalAutoEjectRate, MekanismConfig.general.fluidAutoEjectRate, energyEjectRate);
    }

    public TileComponentEjector(TileEntityMekanism tile, LongSupplier chemicalEjectRate, IntSupplier fluidEjectRate, @Nullable LongSupplier energyEjectRate) {
        this.tile = tile;
        this.chemicalEjectRate = chemicalEjectRate;
        this.fluidEjectRate = fluidEjectRate;
        this.energyEjectRate = energyEjectRate;
        this.outputColorFunction = transporter -> this.outputColor;
        tile.addComponent(this);
    }

    public TileComponentEjector setOutputData(TileComponentConfig config, TransmissionType ... types) {
        for (TransmissionType type : types) {
            ConfigInfo info = config.getConfig(type);
            if (info == null) continue;
            this.configInfo.put(type, info);
        }
        return this;
    }

    public TileComponentEjector setCanEject(Predicate<TransmissionType> canEject) {
        this.canEject = canEject;
        return this;
    }

    public TileComponentEjector setCanTankEject(Predicate<IChemicalTank> canTankEject) {
        this.canTankEject = canTankEject;
        return this;
    }

    public boolean isEjecting(ConfigInfo info, TransmissionType type) {
        return info.isEjecting() && (this.canEject == null || this.canEject.test(type));
    }

    public void tickServer() {
        for (TransmissionType type : EnumUtils.TRANSMISSION_TYPES) {
            ConfigInfo info = this.configInfo.get(type);
            if (info == null || !this.isEjecting(info, type)) continue;
            if (type == TransmissionType.ITEM) {
                if (this.tickDelay == 0) {
                    this.outputItems(this.tile.facingSupplier.get(), info);
                    continue;
                }
                --this.tickDelay;
                continue;
            }
            if (type == TransmissionType.HEAT) continue;
            this.eject(type, this.tile.facingSupplier.get(), info);
        }
    }

    private void addData(Map<Object, Set<Direction>> outputData, Object container, Set<Direction> outputSides) {
        Set<Direction> directions = outputData.get(container);
        if (directions == null) {
            outputSides = EnumSet.copyOf(outputSides);
            outputData.put(container, outputSides);
        } else {
            directions.addAll(outputSides);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void eject(TransmissionType type, Direction facing, ConfigInfo info) {
        IdentityHashMap<Object, Set<Direction>> outputData = null;
        block10: for (DataType dataType : info.getSupportedDataTypes()) {
            Set<Direction> outputSides;
            ISlotInfo slotInfo;
            if (!dataType.canOutput() || (slotInfo = info.getSlotInfo(dataType)) == null || slotInfo.isEmpty() || (outputSides = this.getSidesForData(info, facing, dataType)).isEmpty()) continue;
            if (outputData == null) {
                outputData = new IdentityHashMap<Object, Set<Direction>>();
            }
            Objects.requireNonNull(slotInfo);
            int n = 0;
            block11: while (true) {
                ISlotInfo iSlotInfo;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ChemicalSlotInfo.class, FluidSlotInfo.class, EnergySlotInfo.class}, (Object)iSlotInfo, n)) {
                    case 0: {
                        ChemicalSlotInfo chemicalSlotInfo = (ChemicalSlotInfo)iSlotInfo;
                        if (type != TransmissionType.CHEMICAL) {
                            n = 1;
                            continue block11;
                        }
                        for (IChemicalTank iChemicalTank : chemicalSlotInfo.getTanks()) {
                            if (iChemicalTank.isEmpty() || this.canTankEject != null && !this.canTankEject.test(iChemicalTank)) continue;
                            this.addData(outputData, iChemicalTank, outputSides);
                        }
                        continue block10;
                    }
                    case 1: {
                        FluidSlotInfo fluidSlotInfo = (FluidSlotInfo)iSlotInfo;
                        if (type != TransmissionType.FLUID) {
                            n = 2;
                            continue block11;
                        }
                        for (Object tank2 : fluidSlotInfo.getTanks()) {
                            if (tank2.isEmpty()) continue;
                            this.addData(outputData, tank2, outputSides);
                        }
                        continue block10;
                    }
                    case 2: {
                        Object tank2;
                        EnergySlotInfo energySlotInfo = (EnergySlotInfo)iSlotInfo;
                        if (type != TransmissionType.ENERGY) {
                            n = 3;
                            continue block11;
                        }
                        tank2 = energySlotInfo.getContainers().iterator();
                        while (tank2.hasNext()) {
                            IEnergyContainer container = tank2.next();
                            if (container.isEmpty()) continue;
                            this.addData(outputData, container, outputSides);
                        }
                        continue block10;
                    }
                }
                break;
            }
        }
        if (outputData != null && !outputData.isEmpty()) {
            ServerLevel level = (ServerLevel)this.tile.getLevel();
            BlockPos pos = this.tile.getBlockPos();
            @Nullable Map typeCapabilityCaches = this.capabilityCaches.computeIfAbsent(type, t -> new EnumMap(Direction.class));
            for (Map.Entry entry : outputData.entrySet()) {
                Set sides = (Set)entry.getValue();
                switch (type) {
                    case CHEMICAL: {
                        IChemicalTank tank = (IChemicalTank)entry.getKey();
                        ArrayList<BlockCapabilityCache<IChemicalHandler, Direction>> caches = TileComponentEjector.getCapabilityCaches(level, pos, typeCapabilityCaches, sides, Capabilities.CHEMICAL);
                        ChemicalUtil.emit(caches, tank, this.chemicalEjectRate.getAsLong());
                        break;
                    }
                    case FLUID: {
                        List<BlockCapabilityCache<IFluidHandler, @Nullable Direction>> caches = TileComponentEjector.getCapabilityCaches(level, pos, typeCapabilityCaches, sides, Capabilities.FLUID);
                        FluidUtils.emit(caches, (IExtendedFluidTank)entry.getKey(), this.fluidEjectRate.getAsInt());
                        break;
                    }
                    case ENERGY: {
                        IEnergyContainer container = (IEnergyContainer)entry.getKey();
                        ArrayList<BlockCapabilityCache<IChemicalHandler, Direction>> caches = new ArrayList(sides.size());
                        for (Direction side : sides) {
                            BlockEnergyCapabilityCache cache = this.energyCapabilityCache.get(side);
                            if (cache == null) {
                                cache = BlockEnergyCapabilityCache.create(level, pos.relative(side), side.getOpposite());
                                this.energyCapabilityCache.put(side, cache);
                            }
                            caches.add((BlockCapabilityCache<IChemicalHandler, Direction>)cache);
                        }
                        CableUtils.emit(caches, container, this.energyEjectRate == null ? container.getMaxEnergy() : this.energyEjectRate.getAsLong());
                    }
                }
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static <HANDLER> List<BlockCapabilityCache<HANDLER, @Nullable Direction>> getCapabilityCaches(ServerLevel level, BlockPos pos, Map<Direction, BlockCapabilityCache<?, @Nullable Direction>> typeCapabilityCaches, Set<Direction> sides, IMultiTypeCapability<HANDLER, ?> capability) {
        ArrayList<BlockCapabilityCache<HANDLER, @Nullable Direction>> caches = new ArrayList<BlockCapabilityCache<HANDLER, Direction>>(sides.size());
        for (Direction side : sides) {
            @Nullable Object cache = typeCapabilityCaches.get(side);
            if (cache == null) {
                cache = capability.createCache(level, pos.relative(side), side.getOpposite());
                typeCapabilityCaches.put(side, (BlockCapabilityCache<?, Direction>)cache);
            }
            caches.add((BlockCapabilityCache<HANDLER, Direction>)cache);
        }
        return caches;
    }

    private void outputItems(Direction facing, ConfigInfo info) {
        ServerLevel level = (ServerLevel)this.tile.getLevel();
        Map typeCapabilityCaches = null;
        block0: for (DataType dataType : info.getSupportedDataTypes()) {
            ISlotInfo slotInfo;
            if (!dataType.canOutput() || (slotInfo = info.getSlotInfo(dataType)) != null && slotInfo.isEmpty() || !(slotInfo instanceof InventorySlotInfo)) continue;
            InventorySlotInfo inventorySlotInfo = (InventorySlotInfo)slotInfo;
            Set<Direction> outputs = this.getSidesForData(info, facing, dataType);
            if (outputs.isEmpty()) continue;
            EjectTransitRequest ejectMap = null;
            if (typeCapabilityCaches == null) {
                typeCapabilityCaches = this.capabilityCaches.computeIfAbsent(TransmissionType.ITEM, t -> new EnumMap(Direction.class));
            }
            for (Direction side : outputs) {
                TransitRequest.TransitResponse response;
                IItemHandler capability;
                BlockCapabilityCache<HANDLER, @Nullable Direction> cache = (BlockCapabilityCache)typeCapabilityCaches.get(side);
                if (cache == null) {
                    cache = Capabilities.ITEM.createCache(level, this.tile.getBlockPos().relative(side), side.getOpposite());
                    typeCapabilityCaches.put(side, cache);
                }
                if ((capability = (IItemHandler)cache.getCapability()) == null) continue;
                IItemHandler handler = this.getHandler(side);
                if (ejectMap == null) {
                    ejectMap = InventoryUtils.getEjectItemMap(new EjectTransitRequest(handler), inventorySlotInfo.getSlots());
                    if (ejectMap.isEmpty()) {
                        continue block0;
                    }
                } else {
                    ejectMap.handler = handler;
                }
                if ((response = ejectMap.eject(this.tile, capability, 0, this.outputColorFunction)).isEmpty()) continue;
                response.useAll();
                if (!ejectMap.isEmpty()) continue;
                continue block0;
            }
        }
        this.tickDelay = 10;
    }

    private Set<Direction> getSidesForData(ConfigInfo info, @NotNull Direction facing, @NotNull DataType dataType) {
        EnumSet<Direction> directions = null;
        for (Map.Entry<RelativeSide, DataType> entry : info.getSideConfig()) {
            if (entry.getValue() != dataType) continue;
            if (directions == null) {
                directions = EnumSet.noneOf(Direction.class);
            }
            directions.add(entry.getKey().getDirection(facing));
        }
        return directions == null ? Collections.emptySet() : directions;
    }

    private IItemHandler getHandler(Direction side) {
        return (IItemHandler)CapabilityTileEntity.ITEM_HANDLER_PROVIDER.getCapability((Object)this.tile, (Object)side);
    }

    @ComputerMethod
    public boolean hasStrictInput() {
        return this.strictInput;
    }

    public void setStrictInput(boolean strict) {
        if (this.strictInput != strict) {
            this.strictInput = strict;
            this.tile.markForSave();
        }
    }

    @ComputerMethod
    public EnumColor getOutputColor() {
        return this.outputColor;
    }

    public void setOutputColor(EnumColor color) {
        if (this.outputColor != color) {
            this.outputColor = color;
            this.tile.markForSave();
        }
    }

    public boolean isInputSideEnabled(@NotNull RelativeSide side) {
        ConfigInfo info = this.configInfo.get(TransmissionType.ITEM);
        return info == null || info.isSideEnabled(side);
    }

    public void setInputColor(RelativeSide side, EnumColor color) {
        int ordinal;
        if (this.isInputSideEnabled(side) && this.inputColors[ordinal = side.ordinal()] != color) {
            this.inputColors[ordinal] = color;
            this.tile.markForSave();
        }
    }

    @ComputerMethod
    public EnumColor getInputColor(RelativeSide side) {
        return this.inputColors[side.ordinal()];
    }

    @Override
    public String getComponentKey() {
        return "component_ejector";
    }

    @Override
    public void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        AttachedEjector ejector = (AttachedEjector)input.get(MekanismDataComponents.EJECTOR);
        if (ejector != null) {
            for (int i = 0; i < this.inputColors.length; ++i) {
                this.inputColors[i] = ejector.inputColors().get(i).orElse(null);
            }
            this.strictInput = ejector.strictInput();
            this.outputColor = ejector.outputColor().orElse(null);
        }
    }

    @Override
    public void collectImplicitComponents(DataComponentMap.Builder builder) {
        builder.set(MekanismDataComponents.EJECTOR, (Object)AttachedEjector.create(this.inputColors, this.strictInput, this.outputColor));
    }

    @Override
    public void deserialize(CompoundTag ejectorNBT, HolderLookup.Provider provider) {
        this.strictInput = ejectorNBT.getBoolean("strict_input");
        this.outputColor = NBTUtils.getEnum(ejectorNBT, "color", EnumColor.BY_ID);
        if (ejectorNBT.contains("input_color", 11)) {
            int[] colors = ejectorNBT.getIntArray("input_color");
            for (int i = 0; i < colors.length && i < this.inputColors.length; ++i) {
                this.inputColors[i] = TransporterUtils.readColor(colors[i]);
            }
        } else {
            Arrays.fill(this.inputColors, null);
        }
    }

    @Override
    public CompoundTag serialize(HolderLookup.Provider provider) {
        CompoundTag ejectorNBT = new CompoundTag();
        if (this.strictInput) {
            ejectorNBT.putBoolean("strict_input", true);
        }
        if (this.outputColor != null) {
            NBTUtils.writeEnum(ejectorNBT, "color", this.outputColor);
        }
        int[] colors = new int[this.inputColors.length];
        boolean hasColor = false;
        for (int i = 0; i < this.inputColors.length; ++i) {
            EnumColor color = this.inputColors[i];
            colors[i] = TransporterUtils.getColorIndex(color);
            if (color == null) continue;
            hasColor = true;
        }
        if (hasColor) {
            ejectorNBT.putIntArray("input_color", colors);
        }
        return ejectorNBT;
    }

    @Override
    public List<ISyncableData> getSpecificSyncableData() {
        ArrayList<ISyncableData> list = new ArrayList<ISyncableData>();
        list.add(SyncableBoolean.create(this::hasStrictInput, input -> {
            this.strictInput = input;
        }));
        list.add(SyncableInt.create(() -> TransporterUtils.getColorIndex(this.outputColor), index -> {
            this.outputColor = TransporterUtils.readColor(index);
        }));
        int i = 0;
        while (i < this.inputColors.length) {
            int idx = i++;
            list.add(SyncableInt.create(() -> TransporterUtils.getColorIndex(this.inputColors[idx]), index -> {
                this.inputColors[idx] = TransporterUtils.readColor(index);
            }));
        }
        return list;
    }

    @ComputerMethod(nameOverride="setStrictInput", requiresPublicSecurity=true)
    void computerSetStrictInput(boolean strict) throws ComputerException {
        this.tile.validateSecurityIsPublic();
        this.setStrictInput(strict);
    }

    private void validateInputSide(RelativeSide side) throws ComputerException {
        if (!this.isInputSideEnabled(side)) {
            throw new ComputerException("Side '%s' is disabled and can't be configured.", side);
        }
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void clearInputColor(RelativeSide side) throws ComputerException {
        this.tile.validateSecurityIsPublic();
        this.validateInputSide(side);
        this.setInputColor(side, null);
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void incrementInputColor(RelativeSide side) throws ComputerException {
        this.tile.validateSecurityIsPublic();
        this.validateInputSide(side);
        int ordinal = side.ordinal();
        this.inputColors[ordinal] = TransporterUtils.increment(this.inputColors[ordinal]);
        this.tile.markForSave();
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void decrementInputColor(RelativeSide side) throws ComputerException {
        this.tile.validateSecurityIsPublic();
        this.validateInputSide(side);
        int ordinal = side.ordinal();
        this.inputColors[ordinal] = TransporterUtils.decrement(this.inputColors[ordinal]);
        this.tile.markForSave();
    }

    @ComputerMethod(nameOverride="setInputColor", requiresPublicSecurity=true)
    void computerSetInputColor(RelativeSide side, EnumColor color) throws ComputerException {
        this.tile.validateSecurityIsPublic();
        this.validateInputSide(side);
        this.setInputColor(side, color);
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void clearOutputColor() throws ComputerException {
        this.tile.validateSecurityIsPublic();
        this.setOutputColor(null);
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void incrementOutputColor() throws ComputerException {
        this.tile.validateSecurityIsPublic();
        this.outputColor = TransporterUtils.increment(this.outputColor);
        this.tile.markForSave();
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void decrementOutputColor() throws ComputerException {
        this.tile.validateSecurityIsPublic();
        this.outputColor = TransporterUtils.decrement(this.outputColor);
        this.tile.markForSave();
    }

    @ComputerMethod(nameOverride="setOutputColor", requiresPublicSecurity=true)
    void computerSetOutputColor(EnumColor color) throws ComputerException {
        this.tile.validateSecurityIsPublic();
        this.setOutputColor(color);
    }

    private static class EjectTransitRequest
    extends HandlerTransitRequest {
        public IItemHandler handler;

        public EjectTransitRequest(IItemHandler handler) {
            super(handler);
            this.handler = handler;
        }

        @Override
        protected IItemHandler getHandler() {
            return this.handler;
        }
    }
}

