/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.api.recipes.basic.BasicRotaryRecipe;
import mekanism.common.config.MekanismConfigTranslations;
import mekanism.common.integration.projecte.mappers.TypedMekanismRecipeMapper;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidStackLinkedSet;

@RecipeTypeMapper
public class RotaryRecipeMapper
extends TypedMekanismRecipeMapper<RotaryRecipe> {
    public RotaryRecipeMapper() {
        super(MekanismConfigTranslations.PE_MAPPER_ROTARY, RotaryRecipe.class, MekanismRecipeType.ROTARY);
    }

    @Override
    protected boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, RotaryRecipe recipe, TypedMekanismRecipeMapper.MekFakeGroupHelper fakeGroupHelper) {
        boolean handled = true;
        if (recipe instanceof BasicRotaryRecipe) {
            BasicRotaryRecipe basicRecipe = (BasicRotaryRecipe)recipe;
            if (recipe.hasFluidToChemical()) {
                handled = RotaryRecipeMapper.addConversion(mapper, basicRecipe.getChemicalOutputRaw(), fakeGroupHelper.forIngredient(recipe.getFluidInput()));
            }
            if (recipe.hasChemicalToFluid()) {
                handled |= RotaryRecipeMapper.addConversion(mapper, basicRecipe.getFluidOutputRaw(), fakeGroupHelper.forIngredient(recipe.getChemicalInput()));
            }
        } else {
            if (recipe.hasFluidToChemical()) {
                handled = RotaryRecipeMapper.addConversions(mapper, recipe.getFluidInput(), recipe::getChemicalOutput, ChemicalStack::isEmpty, fakeGroupHelper::forFluids, null, TypedMekanismRecipeMapper::addConversion);
            }
            if (recipe.hasChemicalToFluid()) {
                handled |= RotaryRecipeMapper.addConversions(mapper, recipe.getChemicalInput(), recipe::getFluidOutput, FluidStack::isEmpty, fakeGroupHelper::forChemicals, FluidStackLinkedSet.TYPE_AND_COMPONENTS, TypedMekanismRecipeMapper::addConversion);
            }
        }
        return handled;
    }
}

