/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.transmitter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.DoubleSupplier;
import mekanism.api.IContentsListener;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IHeatHandler;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.heat.CachedAmbientTemperature;
import mekanism.common.capabilities.heat.ITileHeatHandler;
import mekanism.common.capabilities.heat.VariableHeatCapacitor;
import mekanism.common.content.network.HeatNetwork;
import mekanism.common.content.network.transmitter.IUpgradeableTransmitter;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.Color;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.lib.transmitter.acceptor.AbstractAcceptorCache;
import mekanism.common.lib.transmitter.acceptor.AcceptorCache;
import mekanism.common.tier.ConductorTier;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.upgrade.transmitter.ThermodynamicConductorUpgradeData;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThermodynamicConductor
extends Transmitter<IHeatHandler, HeatNetwork, ThermodynamicConductor>
implements ITileHeatHandler,
IUpgradeableTransmitter<ThermodynamicConductorUpgradeData> {
    private final CachedAmbientTemperature ambientTemperature = new CachedAmbientTemperature(this::getLevel, this::getBlockPos);
    public final ConductorTier tier;
    private double clientTemperature = -1.0;
    private final List<IHeatCapacitor> capacitors;
    public final VariableHeatCapacitor buffer;

    public ThermodynamicConductor(Holder<Block> blockProvider, TileEntityTransmitter tile) {
        super(tile, TransmissionType.HEAT);
        this.tier = Attribute.getTier(blockProvider, ConductorTier.class);
        this.buffer = VariableHeatCapacitor.create(this.tier.getHeatCapacity(), this.tier::getInverseConduction, this.tier::getInverseConductionInsulation, (DoubleSupplier)this.ambientTemperature, (IContentsListener)this);
        this.capacitors = Collections.singletonList(this.buffer);
    }

    @Override
    protected AbstractAcceptorCache<IHeatHandler, ?> createAcceptorCache() {
        return new AcceptorCache<IHeatHandler>(this.getTransmitterTile(), Capabilities.HEAT);
    }

    public AcceptorCache<IHeatHandler> getAcceptorCache() {
        return (AcceptorCache)super.getAcceptorCache();
    }

    @Override
    public ConductorTier getTier() {
        return this.tier;
    }

    @Override
    public HeatNetwork createEmptyNetworkWithID(UUID networkID) {
        return new HeatNetwork(networkID);
    }

    @Override
    public HeatNetwork createNetworkByMerging(Collection<HeatNetwork> networks) {
        return new HeatNetwork(networks);
    }

    @Override
    public void takeShare() {
    }

    @Override
    protected boolean isValidAcceptor(@Nullable BlockEntity tile, Direction side) {
        return this.getAcceptorCache().getConnectedAcceptor(side) != null;
    }

    @Override
    @Nullable
    public ThermodynamicConductorUpgradeData getUpgradeData() {
        return new ThermodynamicConductorUpgradeData(this.redstoneReactive, this.getConnectionTypesRaw(), this.buffer.getHeat());
    }

    @Override
    public boolean dataTypeMatches(@NotNull TransmitterUpgradeData data) {
        return data instanceof ThermodynamicConductorUpgradeData;
    }

    @Override
    public void parseUpgradeData(@NotNull ThermodynamicConductorUpgradeData data) {
        this.redstoneReactive = data.redstoneReactive;
        this.setConnectionTypesRaw(data.connectionTypes);
        this.buffer.setHeat(data.heat);
    }

    @Override
    @NotNull
    public CompoundTag write(HolderLookup.Provider provider, @NotNull CompoundTag tag) {
        super.write(provider, tag);
        ContainerType.HEAT.saveTo(provider, tag, this.getHeatCapacitors(null));
        return tag;
    }

    @Override
    public void read(HolderLookup.Provider provider, @NotNull CompoundTag tag) {
        super.read(provider, tag);
        ContainerType.HEAT.readFrom(provider, tag, this.getHeatCapacitors(null));
    }

    @Override
    @NotNull
    public CompoundTag getReducedUpdateTag(@NotNull HolderLookup.Provider provider, CompoundTag updateTag) {
        updateTag = super.getReducedUpdateTag(provider, updateTag);
        updateTag.putDouble("temperature", this.buffer.getHeat());
        return updateTag;
    }

    @Override
    public boolean handleUpdateTag(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        boolean refreshModelData = super.handleUpdateTag(tag, provider);
        NBTUtils.setDoubleIfPresent(tag, "temperature", this.buffer::setHeat);
        return refreshModelData;
    }

    public Color getBaseColor() {
        return this.tier.getBaseColor();
    }

    @Override
    @NotNull
    public List<IHeatCapacitor> getHeatCapacitors(Direction side) {
        return this.capacitors;
    }

    @Override
    public void onContentsChanged() {
        if (!this.isRemote()) {
            if (this.clientTemperature == -1.0) {
                this.clientTemperature = this.ambientTemperature.getAsDouble();
            }
            if (Math.abs(this.buffer.getTemperature() - this.clientTemperature) > this.buffer.getTemperature() / 20.0) {
                this.clientTemperature = this.buffer.getTemperature();
                this.getTransmitterTile().sendUpdatePacket();
            }
        }
        this.getTransmitterTile().setChanged();
    }

    @Override
    public double getAmbientTemperature(@NotNull Direction side) {
        return this.ambientTemperature.getTemperature(side);
    }

    @Override
    @Nullable
    public IHeatHandler getAdjacent(@NotNull Direction side) {
        if (ThermodynamicConductor.connectionMapContainsSide(this.getAllCurrentConnections(), side)) {
            return (IHeatHandler)this.getAcceptorCache().getConnectedAcceptor(side);
        }
        return null;
    }

    @Override
    public double incrementAdjacentTransfer(double currentAdjacentTransfer, double tempToTransfer, @NotNull Direction side) {
        HeatNetwork transmitterNetwork;
        ThermodynamicConductor adjacent;
        if (tempToTransfer > 0.0 && this.hasTransmitterNetwork() && (adjacent = (ThermodynamicConductor)(transmitterNetwork = (HeatNetwork)this.getTransmitterNetwork()).getTransmitter(this.getBlockPos().relative(side))) != null) {
            return currentAdjacentTransfer;
        }
        return ITileHeatHandler.super.incrementAdjacentTransfer(currentAdjacentTransfer, tempToTransfer, side);
    }
}

