/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.distribution;

import java.util.Collection;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.MathUtils;
import mekanism.common.lib.distribution.SplitInfo;
import mekanism.common.lib.distribution.Target;

public class EnergySaveTarget<HANDLER extends SaveHandler>
extends Target<HANDLER, Void> {
    public EnergySaveTarget() {
    }

    public EnergySaveTarget(Collection<HANDLER> allHandlers) {
        super(allHandlers);
    }

    public EnergySaveTarget(int expectedSize) {
        super(expectedSize);
    }

    @Override
    protected void acceptAmount(HANDLER handler, SplitInfo splitInfo, Void unused, long amount) {
        ((SaveHandler)handler).acceptAmount(splitInfo, amount);
    }

    @Override
    protected long simulate(HANDLER handler, Void unused, long amount) {
        return ((SaveHandler)handler).simulate(amount);
    }

    public void save() {
        for (SaveHandler handler : this.handlers) {
            handler.save();
        }
    }

    public long getStored() {
        long total = 0L;
        for (SaveHandler handler : this.handlers) {
            total = MathUtils.addClamped(total, handler.getStored());
        }
        return total;
    }

    @NothingNullByDefault
    public static abstract class SaveHandler {
        private final long maxEnergy;
        private long neededEnergy;

        protected SaveHandler(long maxEnergy) {
            this.neededEnergy = this.maxEnergy = maxEnergy;
        }

        protected void acceptAmount(SplitInfo splitInfo, long amount) {
            if (this.neededEnergy <= 0L) {
                splitInfo.send(0L);
            } else {
                amount = Math.min(amount, this.neededEnergy);
                this.neededEnergy -= amount;
                splitInfo.send(amount);
            }
        }

        protected long simulate(long energyToSend) {
            if (this.neededEnergy <= 0L || energyToSend <= 0L) {
                return 0L;
            }
            return Math.min(energyToSend, this.neededEnergy);
        }

        protected final void save() {
            this.save(this.maxEnergy - this.neededEnergy);
        }

        protected abstract void save(long var1);

        protected abstract long getStored();
    }

    @NothingNullByDefault
    public static class DelegateSaveHandler
    extends SaveHandler {
        private final IEnergyContainer delegate;

        public DelegateSaveHandler(IEnergyContainer delegate) {
            super(delegate.getMaxEnergy());
            this.delegate = delegate;
        }

        @Override
        protected void save(long currentStored) {
            this.delegate.setEnergy(currentStored);
        }

        @Override
        protected long getStored() {
            return this.delegate.getEnergy();
        }
    }
}

