/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.holder.slot;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.RelativeSide;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.capabilities.holder.slot.ConfigInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHolder;
import mekanism.common.capabilities.holder.slot.ReadOnlyInventorySlotHolder;
import mekanism.common.tile.interfaces.ISideConfiguration;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventorySlotHelper {
    private final IInventorySlotHolder slotHolder;
    private boolean built;

    private InventorySlotHelper(IInventorySlotHolder slotHolder) {
        this.slotHolder = slotHolder;
    }

    public static InventorySlotHelper readOnly() {
        return new InventorySlotHelper(new ReadOnlyInventorySlotHolder());
    }

    public static InventorySlotHelper forSide(Supplier<Direction> facingSupplier) {
        return InventorySlotHelper.forSide(facingSupplier, null, null);
    }

    public static InventorySlotHelper forSide(Supplier<Direction> facingSupplier, @Nullable Predicate<RelativeSide> insertPredicate, @Nullable Predicate<RelativeSide> extractPredicate) {
        return new InventorySlotHelper(new InventorySlotHolder(facingSupplier, insertPredicate, extractPredicate));
    }

    public static InventorySlotHelper forSideWithConfig(ISideConfiguration sideConfiguration) {
        return new InventorySlotHelper(new ConfigInventorySlotHolder(sideConfiguration));
    }

    public <SLOT extends IInventorySlot> SLOT addSlot(@NotNull SLOT slot) {
        if (this.built) {
            throw new IllegalStateException("Builder has already built.");
        }
        IInventorySlotHolder iInventorySlotHolder = this.slotHolder;
        Objects.requireNonNull(iInventorySlotHolder);
        IInventorySlotHolder iInventorySlotHolder2 = iInventorySlotHolder;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InventorySlotHolder.class, ReadOnlyInventorySlotHolder.class, ConfigInventorySlotHolder.class}, (Object)iInventorySlotHolder2, n)) {
            case 0: {
                InventorySlotHolder inventorySlotHolder = (InventorySlotHolder)iInventorySlotHolder2;
                inventorySlotHolder.addSlot(slot, new RelativeSide[0]);
                break;
            }
            case 1: {
                ReadOnlyInventorySlotHolder inventorySlotHolder = (ReadOnlyInventorySlotHolder)iInventorySlotHolder2;
                inventorySlotHolder.addSlot(slot);
                break;
            }
            case 2: {
                ConfigInventorySlotHolder inventorySlotHolder = (ConfigInventorySlotHolder)iInventorySlotHolder2;
                inventorySlotHolder.addSlot(slot);
                break;
            }
            default: {
                throw new IllegalArgumentException("Holder does not know how to add slots");
            }
        }
        return slot;
    }

    public <SLOT extends IInventorySlot> SLOT addSlot(@NotNull SLOT slot, RelativeSide ... sides) {
        if (this.built) {
            throw new IllegalStateException("Builder has already built.");
        }
        IInventorySlotHolder iInventorySlotHolder = this.slotHolder;
        if (!(iInventorySlotHolder instanceof InventorySlotHolder)) {
            throw new IllegalArgumentException("Holder does not know how to add slots on specific sides");
        }
        InventorySlotHolder slotHolder = (InventorySlotHolder)iInventorySlotHolder;
        slotHolder.addSlot(slot, sides);
        return slot;
    }

    public IInventorySlotHolder build() {
        this.built = true;
        return this.slotHolder;
    }
}

