/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.attribute;

import java.util.function.Predicate;
import java.util.function.ToIntBiFunction;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeStateActive;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Attributes {
    public static final Attribute ACTIVE = new AttributeStateActive(0);
    public static final Attribute ACTIVE_LIGHT = new AttributeStateActive(8);
    public static final Attribute ACTIVE_MELT_LIGHT = new AttributeStateActive(13);
    public static final Attribute ACTIVE_FULL_LIGHT = new AttributeStateActive(15);
    public static final Attribute COMPARATOR = new AttributeComparator();
    public static final Attribute INVENTORY = new AttributeInventory();
    public static final Attribute REDSTONE = new AttributeRedstone();
    public static final Attribute SECURITY = new AttributeSecurity();

    private Attributes() {
    }

    public static class AttributeComparator
    implements Attribute {
        private AttributeComparator() {
        }
    }

    public static class AttributeInventory<DelayedLootItemBuilder extends ConditionUserBuilder<DelayedLootItemBuilder> & FunctionUserBuilder<DelayedLootItemBuilder>>
    implements Attribute {
        @Nullable
        private final Predicate<DelayedLootItemBuilder> customLootBuilder;

        public AttributeInventory(@Nullable Predicate<DelayedLootItemBuilder> customLootBuilder) {
            this.customLootBuilder = customLootBuilder;
        }

        private AttributeInventory() {
            this(null);
        }

        public boolean applyLoot(DelayedLootItemBuilder builder) {
            return this.customLootBuilder != null && this.customLootBuilder.test(builder);
        }
    }

    public static class AttributeRedstone
    implements Attribute {
        private AttributeRedstone() {
        }
    }

    public static class AttributeSecurity
    implements Attribute {
        private AttributeSecurity() {
        }
    }

    public static class AttributeLight
    implements Attribute {
        private final int light;

        public AttributeLight(int light) {
            this.light = light;
        }

        @Override
        public void adjustProperties(BlockBehaviour.Properties props) {
            BlockStateHelper.applyLightLevelAdjustments(props, state -> this.light);
        }
    }

    public record AttributeCustomResistance(float resistance) implements Attribute
    {
    }

    public static class AttributeRedstoneEmitter<TILE extends TileEntityMekanism>
    implements Attribute.TileAttribute<TILE> {
        private final ToIntBiFunction<TILE, Direction> redstoneFunction;

        public AttributeRedstoneEmitter(ToIntBiFunction<TILE, Direction> redstoneFunction) {
            this.redstoneFunction = redstoneFunction;
        }

        public int getRedstoneLevel(TILE tile, @NotNull Direction side) {
            return this.redstoneFunction.applyAsInt(tile, side);
        }
    }

    public record AttributeCustomPathType(PathCheck pathCheck) implements Attribute
    {
        public static final AttributeCustomPathType WHEN_NOT_FORMED = new AttributeCustomPathType((state, level, pos, mob) -> WorldUtils.isInsideFormedMultiblock(level, pos, mob) ? PathType.DAMAGE_OTHER : null);
    }

    @FunctionalInterface
    public static interface PathCheck {
        @Nullable
        public PathType getBlockPathType(@NotNull BlockState var1, @NotNull BlockGetter var2, @NotNull BlockPos var3, @Nullable Mob var4);
    }

    public static class AttributeMobSpawn
    implements Attribute {
        public static final BlockBehaviour.StateArgumentPredicate<EntityType<?>> NEVER_PREDICATE = (state, reader, pos, entityType) -> false;
        public static final AttributeMobSpawn NEVER = new AttributeMobSpawn(NEVER_PREDICATE);
        public static final AttributeMobSpawn WHEN_NOT_FORMED = new AttributeMobSpawn((state, reader, pos, entityType) -> {
            if (WorldUtils.isInsideFormedMultiblock(reader, pos, null)) {
                return false;
            }
            return state.isFaceSturdy(reader, pos, Direction.UP) && state.getLightEmission(reader, pos) < 14;
        });
        private final BlockBehaviour.StateArgumentPredicate<EntityType<?>> spawningPredicate;

        public AttributeMobSpawn(BlockBehaviour.StateArgumentPredicate<EntityType<?>> spawningPredicate) {
            this.spawningPredicate = spawningPredicate;
        }

        @Override
        public void adjustProperties(BlockBehaviour.Properties props) {
            props.isValidSpawn(this.spawningPredicate);
        }
    }

    public record AttributeComputerIntegration(String name) implements Attribute
    {
    }
}

