/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.data;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.render.data.FluidRenderData;
import mekanism.common.lib.multiblock.IValveHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

@NothingNullByDefault
public class ValveRenderData
extends FluidRenderData {
    private final Direction side;
    private final int valveFluidHeight;

    private ValveRenderData(FluidRenderData renderData, Direction side, BlockPos valveLocation) {
        super(renderData.location, renderData.width, renderData.height, renderData.length, renderData.fluidType);
        this.side = side;
        this.valveFluidHeight = valveLocation.getY() - this.location.getY();
    }

    public static ValveRenderData get(FluidRenderData renderData, IValveHandler.ValveData valveData) {
        return new ValveRenderData(renderData, valveData.side, valveData.location);
    }

    public int getValveFluidHeight() {
        return this.valveFluidHeight;
    }

    public Direction getSide() {
        return this.side;
    }

    @Override
    public boolean equals(Object data) {
        if (data == this) {
            return true;
        }
        if (data == null) {
            return false;
        }
        return data.getClass() == ValveRenderData.class && this.equalsCommonFluid(data) && this.side == ((ValveRenderData)data).side && this.valveFluidHeight == ((ValveRenderData)data).valveFluidHeight;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.side.hashCode();
        result = 31 * result + this.valveFluidHeight;
        return result;
    }
}

