/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.world.features.configs.StructureTargetConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class StructureChorus
extends Feature<StructureTargetConfig> {
    public StructureChorus(Codec<StructureTargetConfig> config) {
        super(config);
    }

    public boolean place(FeaturePlaceContext<StructureTargetConfig> context) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockState chorusFlower = Blocks.CHORUS_FLOWER.defaultBlockState();
        for (int i = 0; i < ((StructureTargetConfig)context.config()).attempts; ++i) {
            mutable.set((Vec3i)context.origin()).move(context.random().nextInt(7) - 3, -1, context.random().nextInt(7) - 3);
            if (!context.level().getBlockState((BlockPos)mutable).isAir() || !context.level().getBlockState(mutable.above()).isAir() || !context.level().getBlockState((BlockPos)mutable.move(Direction.DOWN)).canOcclude()) continue;
            context.level().setBlock((BlockPos)mutable, Blocks.END_STONE.defaultBlockState(), 3);
            if (context.random().nextFloat() < 0.33f) {
                context.level().setBlock((BlockPos)mutable.move(Direction.UP), (BlockState)chorusFlower.setValue((Property)ChorusFlowerBlock.AGE, (Comparable)Integer.valueOf(5 - context.random().nextInt(context.random().nextInt(6) + 1))), 3);
                continue;
            }
            boolean isValidSpot = true;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                mutable.move(direction);
                if (context.level().getBlockState((BlockPos)mutable).is(Blocks.CHORUS_PLANT)) {
                    isValidSpot = false;
                    break;
                }
                mutable.move(direction.getOpposite());
            }
            if (!isValidSpot) continue;
            mutable.move(Direction.UP);
            context.level().setBlock((BlockPos)mutable, (BlockState)((BlockState)Blocks.CHORUS_PLANT.defaultBlockState().setValue((Property)ChorusPlantBlock.DOWN, (Comparable)Boolean.valueOf(true))).setValue((Property)ChorusPlantBlock.UP, (Comparable)Boolean.valueOf(true)), 3);
            Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(context.random());
            if (context.random().nextFloat() < 0.33f || !context.level().getBlockState(mutable.relative(direction)).isAir()) {
                context.level().setBlock((BlockPos)mutable.move(Direction.UP), (BlockState)chorusFlower.setValue((Property)ChorusFlowerBlock.AGE, (Comparable)Integer.valueOf(5 - context.random().nextInt(context.random().nextInt(6) + 1))), 3);
                continue;
            }
            context.level().setBlock((BlockPos)mutable.move(Direction.UP), (BlockState)((BlockState)Blocks.CHORUS_PLANT.defaultBlockState().setValue((Property)ChorusPlantBlock.DOWN, (Comparable)Boolean.valueOf(true))).setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(true)), 3);
            context.level().setBlock((BlockPos)mutable.move(direction), (BlockState)chorusFlower.setValue((Property)ChorusFlowerBlock.AGE, (Comparable)Integer.valueOf(context.random().nextInt(5))), 3);
        }
        return true;
    }
}

