/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import com.mojang.serialization.Codec;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class DripstoneSplatterFeature
extends Feature<NoneFeatureConfiguration> {
    public DripstoneSplatterFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel worldIn = featurePlaceContext.level();
        ChunkGenerator chunkGenerator = featurePlaceContext.chunkGenerator();
        RandomSource rand = featurePlaceContext.random();
        BlockPos pos = featurePlaceContext.origin();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.config();
        int i = 0;
        int j = rand.nextInt(6) + 2;
        for (int k = pos.getX() - j; k <= pos.getX() + j; ++k) {
            block1: for (int l = pos.getZ() - j; l <= pos.getZ() + j; ++l) {
                int j1;
                int i1 = k - pos.getX();
                if (i1 * i1 + (j1 = l - pos.getZ()) * j1 > j * j) continue;
                for (int k1 = pos.getY() - 2; k1 <= pos.getY() + 2; ++k1) {
                    BlockPos blockpos = new BlockPos(k, k1, l);
                    BlockState blockstate = worldIn.getBlockState(blockpos);
                    if (blockstate.getBlock() != Blocks.GRASS_BLOCK) continue;
                    if (!DripstoneSplatterFeature.isAir((LevelSimulatedReader)worldIn, blockpos.above())) continue;
                    worldIn.setBlock(blockpos, Blocks.DRIPSTONE_BLOCK.defaultBlockState(), 2);
                    if (rand.nextInt(5) == 0) {
                        int height = 1 + rand.nextInt(8);
                        DripstoneSplatterFeature.growPointedDripstone((LevelAccessor)worldIn, blockpos.above(), Direction.UP, height, false);
                    }
                    ++i;
                    continue block1;
                }
            }
        }
        return i > 0;
    }

    protected static void growPointedDripstone(LevelAccessor p_190848_, BlockPos p_190849_, Direction p_190850_, int p_190851_, boolean p_190852_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_190849_.mutable();
        DripstoneSplatterFeature.buildBaseToTipColumn(p_190850_, p_190851_, p_190852_, p_309326_ -> {
            if (p_309326_.is(Blocks.POINTED_DRIPSTONE)) {
                p_309326_ = (BlockState)p_309326_.setValue((Property)PointedDripstoneBlock.WATERLOGGED, (Comparable)Boolean.valueOf(p_190848_.isWaterAt((BlockPos)blockpos$mutableblockpos)));
            }
            p_190848_.setBlock((BlockPos)blockpos$mutableblockpos, p_309326_, 2);
            blockpos$mutableblockpos.move(p_190850_);
        });
    }

    protected static void buildBaseToTipColumn(Direction p_159652_, int p_159653_, boolean p_159654_, Consumer<BlockState> p_159655_) {
        if (p_159653_ >= 3) {
            p_159655_.accept(DripstoneSplatterFeature.createPointedDripstone(p_159652_, DripstoneThickness.BASE));
            for (int i = 0; i < p_159653_ - 3; ++i) {
                p_159655_.accept(DripstoneSplatterFeature.createPointedDripstone(p_159652_, DripstoneThickness.MIDDLE));
            }
        }
        if (p_159653_ >= 2) {
            p_159655_.accept(DripstoneSplatterFeature.createPointedDripstone(p_159652_, DripstoneThickness.FRUSTUM));
        }
        if (p_159653_ >= 1) {
            p_159655_.accept(DripstoneSplatterFeature.createPointedDripstone(p_159652_, p_159654_ ? DripstoneThickness.TIP_MERGE : DripstoneThickness.TIP));
        }
    }

    private static BlockState createPointedDripstone(Direction p_159657_, DripstoneThickness p_159658_) {
        return (BlockState)((BlockState)Blocks.POINTED_DRIPSTONE.defaultBlockState().setValue((Property)PointedDripstoneBlock.TIP_DIRECTION, (Comparable)p_159657_)).setValue((Property)PointedDripstoneBlock.THICKNESS, (Comparable)p_159658_);
    }

    public static boolean isAir(LevelSimulatedReader level, BlockPos pos) {
        return level.isStateAtPosition(pos, BlockBehaviour.BlockStateBase::isAir);
    }
}

