/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.configurations;

import biomesoplenty.worldgen.feature.configurations.BOPTreeConfiguration;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;

public class TaigaTreeConfiguration
extends BOPTreeConfiguration {
    public static final Codec<TaigaTreeConfiguration> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockStateProvider.CODEC.fieldOf("trunk_provider").forGetter(instance -> instance.trunkProvider), (App)BlockStateProvider.CODEC.fieldOf("foliage_provider").forGetter(instance -> instance.foliageProvider), (App)BlockStateProvider.CODEC.fieldOf("vine_provider").forGetter(instance -> instance.vineProvider), (App)BlockStateProvider.CODEC.fieldOf("hanging_provider").forGetter(instance -> instance.hangingProvider), (App)BlockStateProvider.CODEC.fieldOf("trunk_fruit_provider").forGetter(instance -> instance.trunkFruitProvider), (App)BlockStateProvider.CODEC.fieldOf("alt_foliage_provider").forGetter(instance -> instance.altFoliageProvider), (App)Codec.INT.fieldOf("min_height").forGetter(instance -> instance.minHeight), (App)Codec.INT.fieldOf("max_height").forGetter(instance -> instance.maxHeight), (App)TreeDecorator.CODEC.listOf().fieldOf("decorators").forGetter(instance -> instance.decorators), (App)Codec.INT.fieldOf("trunk_width").forGetter(instance -> instance.trunkWidth)).apply((Applicative)builder, TaigaTreeConfiguration::new));
    public final int trunkWidth;

    protected TaigaTreeConfiguration(BlockStateProvider trunkProvider, BlockStateProvider foliageProvider, BlockStateProvider vineProvider, BlockStateProvider hangingProvider, BlockStateProvider trunkFruitProvider, BlockStateProvider altFoliageProvider, int minHeight, int maxHeight, List<TreeDecorator> decorators, int trunkWidth) {
        super(trunkProvider, foliageProvider, vineProvider, hangingProvider, trunkFruitProvider, altFoliageProvider, minHeight, maxHeight, decorators);
        this.trunkWidth = trunkWidth;
    }

    public static class Builder
    extends BOPTreeConfiguration.Builder<Builder> {
        private int trunkWidth;

        public Builder() {
            this.minHeight = 6;
            this.maxHeight = 12;
            this.trunkProvider = BlockStateProvider.simple((BlockState)Blocks.SPRUCE_LOG.defaultBlockState());
            this.foliageProvider = BlockStateProvider.simple((BlockState)Blocks.SPRUCE_LEAVES.defaultBlockState());
            this.vineProvider = BlockStateProvider.simple((BlockState)Blocks.VINE.defaultBlockState());
            this.trunkWidth = 1;
        }

        public Builder trunkWidth(int a) {
            this.trunkWidth = a;
            return this;
        }

        @Override
        public TaigaTreeConfiguration build() {
            return new TaigaTreeConfiguration(this.trunkProvider, this.foliageProvider, this.vineProvider, this.hangingProvider, this.trunkFruitProvider, this.altFoliageProvider, this.minHeight, this.maxHeight, this.decorators, this.trunkWidth);
        }
    }
}

