/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block;

import biomesoplenty.api.block.BOPBlocks;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BrambleLeavesBlock
extends DirectionalBlock {
    public static final MapCodec<BrambleLeavesBlock> CODEC = BrambleLeavesBlock.simpleCodec(BrambleLeavesBlock::new);
    protected static final VoxelShape HORIZONTAL = Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    protected static final VoxelShape VERTICAL = Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);

    public BrambleLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP));
    }

    public MapCodec<BrambleLeavesBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (facing == Direction.UP || facing == Direction.DOWN) {
            return VERTICAL;
        }
        return HORIZONTAL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.getOpposite() == stateIn.getValue((Property)FACING) && !stateIn.canSurvive((LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : stateIn;
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockPos blockpos = pos.relative(direction.getOpposite());
        BlockState blockstate = worldIn.getBlockState(blockpos);
        return blockstate.getBlock() == BOPBlocks.BRAMBLE || Block.isShapeFullBlock((VoxelShape)blockstate.getCollisionShape((BlockGetter)worldIn, blockpos));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = super.getStateForPlacement(context);
        Level LevelReader2 = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        if ((blockstate = (BlockState)blockstate.setValue((Property)FACING, (Comparable)direction)).canSurvive((LevelReader)LevelReader2, blockpos)) {
            return blockstate;
        }
        return null;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType computationType) {
        return false;
    }
}

