/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.silkiertouch_common_neoforge.events;

import com.natamus.collective_common_neoforge.functions.ItemFunctions;
import com.natamus.collective_common_neoforge.functions.TaskFunctions;
import com.natamus.collective_common_neoforge.services.Services;
import com.natamus.silkiertouch_common_neoforge.config.ConfigHandler;
import com.natamus.silkiertouch_common_neoforge.mixin.CandleCakeBlockAccessor;
import com.natamus.silkiertouch_common_neoforge.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.InfestedBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.entity.TrialSpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockEvents {
    public static boolean onBlockBreak(Level level, Player player, BlockPos blockPos, BlockState blockState, BlockEntity blockEntity) {
        if (level.isClientSide) {
            return true;
        }
        if (player.isCreative()) {
            return true;
        }
        InteractionHand interactionHand = InteractionHand.MAIN_HAND;
        ItemStack handStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!Util.hasSilkTouch(level, handStack)) {
            interactionHand = InteractionHand.OFF_HAND;
            handStack = player.getItemInHand(InteractionHand.OFF_HAND);
            if (!Util.hasSilkTouch(level, handStack)) {
                return true;
            }
        }
        boolean isPickaxe = Services.TOOLFUNCTIONS.isPickaxe(handStack);
        Block block = blockState.getBlock();
        ItemStack outStack = null;
        if ((ConfigHandler.enableSpawnerDrop && block.equals(Blocks.SPAWNER) || ConfigHandler.enableTrialSpawnerDrop && block.equals(Blocks.TRIAL_SPAWNER)) && isPickaxe) {
            if (blockEntity == null) {
                blockEntity = level.getBlockEntity(blockPos);
            }
            Entity spawnerDisplayEntity = null;
            CompoundTag spawnerData = null;
            if (blockEntity instanceof SpawnerBlockEntity) {
                SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
                spawnerDisplayEntity = spawnerBlockEntity.getSpawner().getOrCreateDisplayEntity(level, blockPos);
                spawnerData = spawnerBlockEntity.saveCustomAndMetadata((HolderLookup.Provider)level.registryAccess());
            } else if (blockEntity instanceof TrialSpawnerBlockEntity) {
                TrialSpawnerBlockEntity trialSpawnerBlockEntity = (TrialSpawnerBlockEntity)blockEntity;
                spawnerData = trialSpawnerBlockEntity.saveCustomAndMetadata((HolderLookup.Provider)level.registryAccess());
            }
            outStack = blockState.getBlock().getCloneItemStack((LevelReader)level, blockPos, blockState);
            if (spawnerData != null) {
                CompoundTag compoundTag = new CompoundTag();
                compoundTag.put("spawnerData", (Tag)spawnerData);
                outStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)compoundTag));
                if (spawnerDisplayEntity != null) {
                    outStack.set(DataComponents.CUSTOM_NAME, (Object)spawnerDisplayEntity.getName().copy().append((Component)Component.literal((String)" ").append((Component)block.getName())));
                }
            }
        } else if (ConfigHandler.enableFullCakeDrop && block instanceof CakeBlock) {
            if ((Integer)blockState.getValue((Property)CakeBlock.BITES) == 0) {
                outStack = new ItemStack((ItemLike)block);
            }
        } else if (ConfigHandler.enableFullCakeDrop && block instanceof CandleCakeBlock) {
            outStack = new ItemStack((ItemLike)Blocks.CAKE);
            CandleBlock candleBlock = ((CandleCakeBlockAccessor)block).getCandleBlock();
            if (candleBlock != null) {
                level.addFreshEntity((Entity)new ItemEntity(level, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5, new ItemStack((ItemLike)candleBlock)));
            }
        } else if (ConfigHandler.enableBuddedAmethystDrop && block instanceof BuddingAmethystBlock && isPickaxe || ConfigHandler.enableFarmlandDrop && block instanceof FarmBlock || ConfigHandler.enableTallGrassDrop && block instanceof TallGrassBlock || ConfigHandler.enableVinesDrop && block instanceof VineBlock || ConfigHandler.enableSnowLayerDrop && block instanceof SnowLayerBlock || ConfigHandler.enableInfestedStoneDrop && block instanceof InfestedBlock && isPickaxe) {
            outStack = blockState.getBlock().getCloneItemStack((LevelReader)level, blockPos, blockState);
        }
        if (outStack != null) {
            level.addFreshEntity((Entity)new ItemEntity(level, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5, outStack));
            level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 3);
            ItemFunctions.itemHurtBreakAndEvent((ItemStack)handStack, (ServerPlayer)((ServerPlayer)player), (InteractionHand)interactionHand, (int)1);
            return false;
        }
        return true;
    }

    public static boolean onEntityBlockPlace(Level level, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        if (level.isClientSide) {
            return true;
        }
        if (!(livingEntity instanceof Player)) {
            return true;
        }
        Player player = (Player)livingEntity;
        ItemStack handStack = player.getItemInHand(InteractionHand.MAIN_HAND);
        Item handItem = handStack.getItem();
        if (!Util.isSpawnerItem(handItem) && !Util.isSpawnerItem(handItem = (handStack = player.getItemInHand(InteractionHand.OFF_HAND)).getItem())) {
            return true;
        }
        CustomData customData = (CustomData)handStack.get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            return true;
        }
        CompoundTag compoundTag = customData.copyTag();
        if (!compoundTag.contains("spawnerData")) {
            return true;
        }
        CompoundTag spawnerData = (CompoundTag)compoundTag.get("spawnerData");
        if (spawnerData == null) {
            return true;
        }
        level.setBlock(blockPos, blockState, 3);
        TaskFunctions.enqueueCollectiveServerTask((MinecraftServer)level.getServer(), () -> {
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof SpawnerBlockEntity) {
                SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
                spawnerBlockEntity.loadWithComponents(spawnerData, (HolderLookup.Provider)level.registryAccess());
            } else if (blockEntity instanceof TrialSpawnerBlockEntity) {
                TrialSpawnerBlockEntity trialSpawnerBlockEntity = (TrialSpawnerBlockEntity)blockEntity;
                trialSpawnerBlockEntity.loadWithComponents(spawnerData, (HolderLookup.Provider)level.registryAccess());
            }
        }, (int)0);
        handStack.shrink(1);
        return false;
    }
}

