/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.util;

import java.util.List;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class TeleportationUtils {
    public static Entity teleportEntity(Entity entity, ResourceKey<Level> dimension, double xCoord, double yCoord, double zCoord, float yaw, float pitch) {
        return TeleportationUtils.teleportEntityTo(entity, new Vector3f((float)xCoord, (float)yCoord, (float)zCoord), dimension, yaw, pitch);
    }

    public static Entity teleportEntityTo(Entity entity, Vector3f target, ResourceKey<Level> destinationDimension, float yaw, float pitch) {
        if (entity.getCommandSenderWorld().dimension() == destinationDimension) {
            entity.setYRot(yaw);
            entity.setXRot(pitch);
            entity.teleportTo((double)target.x() + 0.5, (double)target.y(), (double)target.z() + 0.5);
            if (!entity.getPassengers().isEmpty()) {
                ((ServerChunkCache)entity.getCommandSenderWorld().getChunkSource()).broadcast(entity, (Packet)new ClientboundSetPassengersPacket(entity));
            }
            return entity;
        }
        ServerLevel newWorld = ((ServerLevel)entity.getCommandSenderWorld()).getServer().getLevel(destinationDimension);
        if (newWorld != null) {
            Vec3 destination = new Vec3((double)target.x() + 0.5, (double)target.y(), (double)target.z() + 0.5);
            List passengers = entity.getPassengers();
            DimensionTransition transition = new DimensionTransition(newWorld, destination, entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), et -> {
                for (Entity passenger : passengers) {
                    TeleportationUtils.teleportPassenger(newWorld, et, passenger);
                }
            });
            return entity.changeDimension(transition);
        }
        return null;
    }

    private static void teleportPassenger(ServerLevel destWorld, Entity repositionedEntity, Entity passenger) {
        List passengers = passenger.getPassengers();
        passenger.changeDimension(new DimensionTransition(destWorld, repositionedEntity.position(), passenger.getDeltaMovement(), passenger.getYRot(), passenger.getXRot(), et -> {
            repositionedEntity.startRiding(repositionedEntity, true);
            for (Entity pas : passengers) {
                TeleportationUtils.teleportPassenger(destWorld, et, pas);
            }
        }));
    }
}

