/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.api;

import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.ArrayUtils;

@FunctionalInterface
public interface IItemStackQuery
extends Predicate<ItemStack> {
    public static final IItemStackQuery ANYTHING = stack -> true;
    public static final IItemStackQuery NOTHING = stack -> false;

    public static IItemStackQuery of(Item item) {
        return new ItemQuery(item);
    }

    public static IItemStackQuery of(ItemStack stack) {
        return new ItemStackQuery(stack);
    }

    public static IItemStackQuery of(Block block) {
        return IItemStackQuery.of(block.asItem());
    }

    public boolean matches(ItemStack var1);

    @Override
    default public boolean test(ItemStack stack) {
        return this.matches(stack);
    }

    default public BiPredicate<ItemStack, Integer> toSlotFilter(int ... slots) {
        return this.toSlotFilter(slot -> ArrayUtils.contains((int[])slots, (int)slot));
    }

    default public BiPredicate<ItemStack, Integer> toSlotFilter(Predicate<Integer> slotPredicate) {
        return (stack, slot) -> slotPredicate.test((Integer)slot) && this.test((ItemStack)stack);
    }

    default public BiPredicate<ItemStack, Integer> toSlotFilter(int min, int max) {
        return this.toSlotFilter(slot -> slot >= min && slot <= max);
    }

    default public BiPredicate<ItemStack, Integer> toSlotFilter() {
        return this.toSlotFilter(slot -> true);
    }

    public static class ItemQuery
    implements IItemStackQueryRecipe {
        protected Item item;

        public ItemQuery(Item item) {
            this.item = item;
        }

        public Item getItem() {
            return this.item;
        }

        @Override
        public ItemStack[] getMatchingStacks() {
            return new ItemStack[]{new ItemStack((ItemLike)this.item)};
        }

        @Override
        public boolean matches(ItemStack itemStack) {
            return itemStack.getItem().equals(this.item);
        }
    }

    public static class ItemStackQuery
    implements IItemStackQueryRecipe {
        protected ItemStack stack;

        public ItemStackQuery(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public boolean matches(ItemStack stack) {
            return ItemStack.matches((ItemStack)this.stack, (ItemStack)stack);
        }

        @Override
        public ItemStack[] getMatchingStacks() {
            return new ItemStack[]{this.stack};
        }
    }

    public static class IngredientQuery
    implements IItemStackQueryRecipe {
        protected Ingredient ingredient;

        public IngredientQuery(Ingredient ingredient) {
            this.ingredient = ingredient;
        }

        @Override
        public ItemStack[] getMatchingStacks() {
            return this.ingredient.getItems();
        }

        public Ingredient getIngredient() {
            return this.ingredient;
        }

        @Override
        public boolean matches(ItemStack itemStack) {
            return this.ingredient.test(itemStack);
        }
    }

    @FunctionalInterface
    public static interface IItemStackNBTQuery
    extends IItemStackQuery {
        @Override
        default public boolean matches(ItemStack itemStack) {
            return false;
        }

        public boolean matches(CompoundTag var1);
    }

    public static interface IItemStackQueryRecipe
    extends IItemStackQuery {
        public ItemStack[] getMatchingStacks();
    }
}

