/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.integration;

import com.illusivesoulworks.polymorph.api.client.PolymorphWidgets;
import com.illusivesoulworks.polymorph.api.client.widgets.PlayerRecipesWidget;
import com.illusivesoulworks.polymorph.client.RecipesWidget;
import moonfather.workshop_for_handsome_adventurer.block_entities.messaging.PacketSender;
import moonfather.workshop_for_handsome_adventurer.block_entities.screens.SimpleTableCraftingScreen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;

public class PolymorphAccessorClient {
    public static void setTargetSlot(Slot slot) {
        RecipesWidget.get().ifPresent(widget -> {
            if (widget instanceof OurPlayerRecipesWidget) {
                OurPlayerRecipesWidget ourWidget = (OurPlayerRecipesWidget)((Object)widget);
                ourWidget.setDestinationSlot(slot);
            }
        });
    }

    public static void updatePosition() {
        RecipesWidget.get().ifPresent(widget -> {
            if (widget instanceof OurPlayerRecipesWidget) {
                OurPlayerRecipesWidget ourWidget = (OurPlayerRecipesWidget)((Object)widget);
                ourWidget.updatePosition();
            }
        });
    }

    public static void register() {
        PolymorphWidgets.getInstance().registerWidget(containerScreen -> {
            if (containerScreen instanceof SimpleTableCraftingScreen) {
                return new OurPlayerRecipesWidget(containerScreen, (Slot)containerScreen.getMenu().slots.get(0));
            }
            return null;
        });
    }

    private static class OurPlayerRecipesWidget
    extends PlayerRecipesWidget {
        private Slot output;

        public OurPlayerRecipesWidget(AbstractContainerScreen<?> containerScreen, Slot outputSlot) {
            super(containerScreen, outputSlot);
            this.output = outputSlot;
        }

        public void setDestinationSlot(Slot newOutput) {
            this.output = newOutput;
            this.resetWidgetOffsets();
        }

        public Slot getOutputSlot() {
            return this.output;
        }

        public void updatePosition() {
            this.resetWidgetOffsets();
            this.openButton.setPosition(this.getXPos(), this.getYPos());
        }

        public void selectRecipe(ResourceLocation resourceLocation) {
            super.selectRecipe(resourceLocation);
            PacketSender.sendCraftingResultUpdateRequestToServer(this.getOutputSlot().index);
        }
    }
}

