/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.dynamic_resources.texture_finder;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.texture_finder.ITextureFinder;
import net.neoforged.fml.ModList;

public class TextureAutoFinderBackup
implements ITextureFinder {
    private static final Pattern PATTERN_IN_BLOCKSTATE = Pattern.compile("\"(model)\"\\s*:\\s*\"([a-z0-9_]+:)?(.+?)\"");
    private static final Pattern PATTERN_IN_MODEL_ALL = Pattern.compile("\"(all|south)\"\\s*:\\s*\"([a-z0-9_]+:)?(.+?)\"");
    private static final Pattern PATTERN_IN_MODEL_SIDE = Pattern.compile("\"(side|south)\"\\s*:\\s*\"([a-z0-9_]+:)?(.+?)\"");
    private static final Map<String, String> PATH_CACHE = new HashMap<String, String>();

    public static ITextureFinder create() {
        return new TextureAutoFinderBackup();
    }

    @Override
    public String getTexturePathForPlanks(String modId, String wood, String blockNameTemplate) {
        return TextureAutoFinderBackup.getTexturePathInternal(modId, wood, blockNameTemplate, false);
    }

    @Override
    public String getTexturePathForLogs(String modId, String wood, String blockNameTemplate) {
        return TextureAutoFinderBackup.getTexturePathInternal(modId, wood, blockNameTemplate, true);
    }

    private static String getTexturePathInternal(String modId, String wood, String blockTemplate, boolean textureIsSide) {
        String key = "%s:%s/%s".formatted(modId, wood, textureIsSide ? "s" : "a");
        if (PATH_CACHE.containsKey(key)) {
            return PATH_CACHE.get(key);
        }
        try {
            Path blockStatePath = ModList.get().getModFileById(modId).getFile().findResource(new String[]{"assets", modId, "blockstates", blockTemplate.formatted(wood) + ".json"});
            String file1 = Files.readString(blockStatePath);
            Matcher m1 = PATTERN_IN_BLOCKSTATE.matcher(file1);
            m1.find();
            String path1 = m1.group(3);
            Path modelPath = ModList.get().getModFileById(modId).getFile().findResource(new String[]{"/assets/%s/models/%s.json".formatted(modId, path1)});
            String file2 = Files.readString(modelPath);
            Matcher m2 = (textureIsSide ? PATTERN_IN_MODEL_SIDE : PATTERN_IN_MODEL_ALL).matcher(file2);
            m2.find();
            String result = m2.group(3);
            PATH_CACHE.put(key, result);
            return result;
        }
        catch (Exception e) {
            System.out.println("!!~~ " + e.getMessage());
            return null;
        }
    }
}

