/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.dynamic_resources;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.HashSet;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.WoodTypeLister;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.helpers.BlockTagWriter2;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;

public class MissingMappingsHandler {
    private static final HashSet<String> earlierTypes = new HashSet();

    public static void prepareMappings() {
        for (String earlier : earlierTypes) {
            if (WoodTypeLister.getWoodIds().contains(earlier)) continue;
            for (String prefix : BlockTagWriter2.files) {
                ResourceLocation missing = ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)(prefix + earlier));
                ResourceLocation fallback = ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)(prefix + "oak"));
                BuiltInRegistries.BLOCK.addAlias(missing, fallback);
            }
        }
    }

    public static void read() {
        String raw = "";
        try {
            Path path = Path.of("config", "workshop", "mappings.dat");
            raw = Files.readString(path);
        }
        catch (IOException iOException) {
        }
        Arrays.stream(raw.split(",\\s*")).forEach(earlierTypes::add);
        earlierTypes.remove("");
    }

    public static void storeForNextTime() {
        WoodTypeLister.getWoodIds().forEach(earlierTypes::add);
        String raw = String.join((CharSequence)", ", earlierTypes);
        try {
            Path path = Path.of("config", "workshop", "mappings.dat");
            Files.writeString(path, (CharSequence)raw, StandardOpenOption.CREATE_NEW);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

