/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.dynamic_resources;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.DAGResourceReader;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.config.DynamicAssetClientConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.neoforged.fml.ModList;

public abstract class AssetReader {
    private static AssetReader serverReader = null;
    private static AssetReader clientReader = null;

    public static AssetReader getInstance(PackType packType, String namespace) {
        if (packType.equals((Object)PackType.SERVER_DATA)) {
            if (serverReader == null) {
                serverReader = DynamicAssetClientConfig.UseDAG.isTrue() && ModList.get().isLoaded("dynamic_asset_generator") ? new DAGResourceReader(packType, namespace) : new RawResourceReader(packType, namespace);
            }
            return serverReader;
        }
        if (packType.equals((Object)PackType.CLIENT_RESOURCES)) {
            if (clientReader == null) {
                clientReader = DynamicAssetClientConfig.UseDAG.isTrue() && ModList.get().isLoaded("dynamic_asset_generator") ? new DAGResourceReader(packType, namespace) : new RawResourceReader(packType, namespace);
            }
            return clientReader;
        }
        return null;
    }

    public abstract InputStream getStream(ResourceLocation var1);

    public String getText(ResourceLocation location) {
        InputStream is = this.getStream(location);
        if (is == null) {
            return null;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        return in.lines().collect(Collectors.joining("\n"));
    }

    private static class RawResourceReader
    extends AssetReader {
        private final String prefix;

        public RawResourceReader(PackType packType, String namespace) {
            this.prefix = packType.equals((Object)PackType.SERVER_DATA) ? "/data/" + namespace + "/" : "/assets/" + namespace + "/";
        }

        @Override
        public InputStream getStream(ResourceLocation location) {
            String path = this.prefix + location.getPath();
            return this.getClass().getResourceAsStream(path);
        }
    }
}

