/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities.messaging;

import moonfather.workshop_for_handsome_adventurer.block_entities.DualTableMenu;
import moonfather.workshop_for_handsome_adventurer.block_entities.SimpleTableMenu;
import moonfather.workshop_for_handsome_adventurer.block_entities.messaging.ChestRenameMessage;
import moonfather.workshop_for_handsome_adventurer.block_entities.messaging.ClientRequestMessage;
import moonfather.workshop_for_handsome_adventurer.block_entities.messaging.CraftingUpdateRequestMessage;
import moonfather.workshop_for_handsome_adventurer.block_entities.messaging.GridChangeMessage;
import moonfather.workshop_for_handsome_adventurer.block_entities.messaging.TabChangeMessage;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PayloadHandler {
    private PayloadHandler() {
    }

    public static void handleMessage(ChestRenameMessage message, IPayloadContext context) {
        try {
            Player player = context.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                player = sp.containerMenu;
                if (player instanceof SimpleTableMenu) {
                    SimpleTableMenu menu = (SimpleTableMenu)player;
                    menu.renameChest(message.value());
                }
            }
        }
        catch (Exception e) {
            context.disconnect((Component)Component.literal((String)("Networking error in WFHA mod, msg1:  \n" + e.getMessage())));
        }
    }

    public static void handleMessage(ClientRequestMessage message, IPayloadContext context) {
        try {
            Player player = context.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                player = sp.containerMenu;
                if (player instanceof SimpleTableMenu) {
                    SimpleTableMenu menu = (SimpleTableMenu)player;
                    if (message.value() == 5) {
                        menu.sendAllDataToRemote();
                        menu.broadcastChanges();
                    }
                }
            }
        }
        catch (Exception e) {
            context.disconnect((Component)Component.literal((String)("Networking error in WFHA mod, msg2:  \n" + e.getMessage())));
        }
    }

    public static void handleMessage(GridChangeMessage message, IPayloadContext context) {
        try {
            Player player = context.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                player = sp.containerMenu;
                if (player instanceof DualTableMenu) {
                    DualTableMenu menu = (DualTableMenu)player;
                    menu.changeRecipeTargetGridTo(message.destination());
                }
            }
        }
        catch (Exception e) {
            context.disconnect((Component)Component.literal((String)("Networking error in WFHA mod, msg3:  \n" + e.getMessage())));
        }
    }

    public static void handleMessage(TabChangeMessage message, IPayloadContext context) {
        try {
            Player player = context.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                player = sp.containerMenu;
                if (player instanceof SimpleTableMenu) {
                    SimpleTableMenu menu = (SimpleTableMenu)player;
                    menu.changeTabTo(message.tab());
                }
            }
        }
        catch (Exception e) {
            context.disconnect((Component)Component.literal((String)("Networking error in WFHA mod, msg4:  \n" + e.getMessage())));
        }
    }

    public static void handleMessage(CraftingUpdateRequestMessage message, IPayloadContext context) {
        try {
            Player player = context.player();
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                player = sp.containerMenu;
                if (player instanceof SimpleTableMenu) {
                    SimpleTableMenu menu = (SimpleTableMenu)player;
                    menu.handleCraftingUpdateRequest(message.value());
                }
            }
        }
        catch (Exception e) {
            context.disconnect((Component)Component.literal((String)("Networking error in WFHA mod, msg5:  \n" + e.getMessage())));
        }
    }
}

