/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities;

import java.util.LinkedList;
import moonfather.workshop_for_handsome_adventurer.block_entities.SimpleTableMenu;
import moonfather.workshop_for_handsome_adventurer.block_entities.containers.ItemContainerContentsWrapper;
import moonfather.workshop_for_handsome_adventurer.block_entities.containers.container_translators.MultipartBarrelsSimpleTranslator;
import moonfather.workshop_for_handsome_adventurer.block_entities.containers.container_translators.StorageDrawersSimpleTranslator;
import moonfather.workshop_for_handsome_adventurer.block_entities.containers.container_translators.TetraBeltTranslator;
import moonfather.workshop_for_handsome_adventurer.blocks.AdvancedTableBottomPrimary;
import moonfather.workshop_for_handsome_adventurer.initialization.Registration;
import moonfather.workshop_for_handsome_adventurer.integration.BackpackAccessor;
import moonfather.workshop_for_handsome_adventurer.integration.BackpackedBackpack;
import moonfather.workshop_for_handsome_adventurer.integration.TetraBeltSupport;
import moonfather.workshop_for_handsome_adventurer.integration.TravelersBackpack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class InventoryAccessHelper {
    private LinkedList<InventoryAccessRecord> adjacentInventories = null;
    public String currentType;
    public Container chosenContainer;
    public int chosenContainerTrueSize = 0;
    public int chosenContainerVisibleSize = 0;
    private BlockPos chestPrimaryPos;
    public BlockEntity chosenContainerForRename = null;
    public ItemStack chosenContainerItem = null;

    private void resolveBlockContainer(BlockEntity be, Player player, BlockPos pos, Level level) {
        Container container;
        IItemHandler handler;
        ChestBlockEntity cbe;
        this.chosenContainer = null;
        this.chestPrimaryPos = null;
        this.chosenContainerTrueSize = 0;
        this.currentType = "";
        this.chosenContainerVisibleSize = 27;
        this.chosenContainerForRename = null;
        if (be == null) {
            return;
        }
        if (be instanceof ChestBlockEntity && (cbe = (ChestBlockEntity)be).getContainerSize() <= 54) {
            CompoundContainer result;
            BlockEntity be2;
            BlockPos pos2;
            if (ChestBlock.isChestBlockedAt((LevelAccessor)level, (BlockPos)pos)) {
                return;
            }
            this.chosenContainerTrueSize = cbe.getContainerSize();
            this.chosenContainerVisibleSize = cbe.getContainerSize() <= 27 ? 27 : 54;
            this.currentType = "block";
            DoubleBlockCombiner.BlockType type = ChestBlock.getBlockType((BlockState)be.getBlockState());
            if (type == DoubleBlockCombiner.BlockType.SINGLE) {
                this.chosenContainer = new SimpleTableMenu.VariableSizeContainerWrapper((Container)be, true);
                this.chosenContainerForRename = be;
            }
            if (type == DoubleBlockCombiner.BlockType.FIRST) {
                pos2 = pos.relative(ChestBlock.getConnectedDirection((BlockState)be.getBlockState()));
                be2 = level.getBlockEntity(pos2);
                if (be2 instanceof ChestBlockEntity && be2.getBlockState().getValue((Property)ChestBlock.TYPE) != be.getBlockState().getValue((Property)ChestBlock.TYPE)) {
                    if (ChestBlock.isChestBlockedAt((LevelAccessor)level, (BlockPos)pos2)) {
                        return;
                    }
                    result = new CompoundContainer((Container)be, (Container)be2);
                    this.chosenContainer = result.getContainerSize() == 54 ? result : new SimpleTableMenu.VariableSizeContainerWrapper((Container)result, true);
                    this.chosenContainerTrueSize = result.getContainerSize();
                    this.chosenContainerVisibleSize = result.getContainerSize() <= 27 ? 27 : 54;
                    this.chosenContainerForRename = be;
                } else {
                    return;
                }
            }
            if (type == DoubleBlockCombiner.BlockType.SECOND) {
                pos2 = pos.relative(ChestBlock.getConnectedDirection((BlockState)be.getBlockState()));
                be2 = level.getBlockEntity(pos2);
                if (be2 instanceof ChestBlockEntity && be2.getBlockState().getValue((Property)ChestBlock.TYPE) != be.getBlockState().getValue((Property)ChestBlock.TYPE)) {
                    if (ChestBlock.isChestBlockedAt((LevelAccessor)level, (BlockPos)pos2)) {
                        return;
                    }
                    result = new CompoundContainer((Container)be2, (Container)be);
                    this.chosenContainer = result.getContainerSize() == 54 ? result : new SimpleTableMenu.VariableSizeContainerWrapper((Container)result, true);
                    this.chosenContainerTrueSize = result.getContainerSize();
                    this.chosenContainerVisibleSize = result.getContainerSize() <= 27 ? 27 : 54;
                    this.chosenContainerForRename = be2;
                    this.chestPrimaryPos = pos2;
                } else {
                    return;
                }
            }
            return;
        }
        if (be.getBlockState().getBlock().getDescriptionId().contains("mm_storage")) {
            if (!be.getBlockState().getBlock().getDescriptionId().contains("barrel")) {
                return;
            }
            handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)null);
            if (handler != null) {
                this.chosenContainer = new SimpleTableMenu.VariableSizeContainerWrapper((Container)new MultipartBarrelsSimpleTranslator(handler), false);
                this.chosenContainerTrueSize = handler.getSlots() - 1;
                this.chosenContainerVisibleSize = 27;
                this.currentType = "block";
                return;
            }
        }
        if (be instanceof Container && (container = (Container)be).getContainerSize() <= 54) {
            boolean isShulkerBox = false;
            if (be instanceof ShulkerBoxBlockEntity) {
                isShulkerBox = true;
                if (!InventoryAccessHelper.canOpenShulkerBox(level, be.getBlockState(), pos)) {
                    return;
                }
            }
            this.chosenContainer = new SimpleTableMenu.VariableSizeContainerWrapper(container, !isShulkerBox);
            this.chosenContainerTrueSize = container.getContainerSize();
            this.chosenContainerVisibleSize = container.getContainerSize() <= 27 ? 27 : 54;
            this.chosenContainerForRename = be;
            this.currentType = "block";
            return;
        }
        if (be instanceof EnderChestBlockEntity) {
            if (ChestBlock.isChestBlockedAt((LevelAccessor)level, (BlockPos)pos)) {
                return;
            }
            this.chosenContainer = new SimpleTableMenu.VariableSizeContainerWrapper((Container)player.getEnderChestInventory(), true);
            this.chosenContainerTrueSize = 27;
            this.chosenContainerVisibleSize = 27;
            this.currentType = "block";
            return;
        }
        if (be.getBlockState().getBlock().getDescriptionId().contains("storagedrawers") && (handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)null)) != null) {
            this.chosenContainer = new SimpleTableMenu.VariableSizeContainerWrapper((Container)new StorageDrawersSimpleTranslator(handler), false);
            this.chosenContainerTrueSize = handler.getSlots() - 1;
            this.chosenContainerVisibleSize = this.chosenContainerTrueSize <= 27 ? 27 : 54;
            this.currentType = "block";
            return;
        }
        handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)null);
        if (handler == null) {
            handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)Direction.UP);
        }
        if (handler != null && handler.getSlots() <= 54) {
            this.chosenContainer = new SimpleTableMenu.VariableSizeItemStackHandlerWrapper(handler, true);
            this.chosenContainerTrueSize = handler.getSlots();
            this.chosenContainerVisibleSize = this.chosenContainerTrueSize <= 27 ? 27 : 54;
            this.chosenContainerForRename = be;
            this.currentType = "block";
            return;
        }
    }

    private static boolean canOpenShulkerBox(Level level, BlockState blockState, BlockPos pos) {
        AABB aabb = Shulker.getProgressDeltaAabb((float)1.0f, (Direction)((Direction)blockState.getValue((Property)DirectionalBlock.FACING)), (float)0.0f, (float)0.5f).move(pos).deflate(1.0E-6);
        return level.noCollision(aabb);
    }

    public void loadAdjacentInventories(Level level, BlockPos pos, Player player, int inventoryAccessRange) {
        if (this.adjacentInventories == null) {
            this.adjacentInventories = new LinkedList();
        }
        this.adjacentInventories.clear();
        this.loadAdjacentInventoriesCore(level, pos, player, inventoryAccessRange);
        BlockState statePrimary = level.getBlockState(pos);
        BlockPos posSecondary = null;
        if (statePrimary.getBlock() instanceof AdvancedTableBottomPrimary) {
            posSecondary = pos.relative(((Direction)statePrimary.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getCounterClockWise());
            this.loadAdjacentInventoriesCore(level, posSecondary, player, inventoryAccessRange);
        }
        this.loadNonBlockInventories(level, player);
        this.sort(pos, posSecondary);
        while (this.adjacentInventories.size() > 16) {
            this.adjacentInventories.removeLast();
        }
    }

    private void loadNonBlockInventories(Level level, Player player) {
        ItemStack icon;
        ItemStack icon2;
        InventoryAccessRecord record;
        int size;
        Object beltSearch = TetraBeltSupport.findToolbelt(player);
        if (TetraBeltSupport.hasToolbelt(beltSearch) && (size = TetraBeltSupport.getToolbeltStorage(beltSearch).getContainerSize()) > 0) {
            record = new InventoryAccessRecord();
            record.ItemChest = TetraBeltSupport.getToolbeltIcon(beltSearch);
            record.Nameable = true;
            record.Name = record.ItemChest.getHoverName();
            record.Type = "belt";
            record.VisibleSlotCount = size / 8 * 9 <= 27 ? 27 : 54;
            record.ItemFirst = TetraBeltSupport.getToolbeltStorageFirst(beltSearch);
            record.Index = this.adjacentInventories.size();
            record.ModId = "tetra";
            this.adjacentInventories.add(record);
        }
        for (int slot = 0; slot < RecordTypes.NAMED_SLOTS.length; ++slot) {
            String slotName = RecordTypes.NAMED_SLOTS[slot];
            ItemStack maybeStorageItem = InventoryAccessHelper.getItemFromNamedSlot(player, slotName);
            IItemHandler itemHandler = (IItemHandler)maybeStorageItem.getCapability(Capabilities.ItemHandler.ITEM, null);
            if (itemHandler != null) {
                InventoryAccessRecord record2 = new InventoryAccessRecord();
                record2.ItemChest = maybeStorageItem.copy();
                record2.Nameable = true;
                record2.Name = record2.ItemChest.getHoverName();
                record2.Type = slotName;
                record2.VisibleSlotCount = itemHandler.getSlots() <= 27 ? 27 : 54;
                record2.ItemFirst = ItemStack.EMPTY;
                record2.Index = this.adjacentInventories.size();
                this.adjacentInventories.add(record2);
                record2.ModId = "";
                continue;
            }
            ItemContainerContents container = (ItemContainerContents)maybeStorageItem.get(DataComponents.CONTAINER);
            if (container == null || maybeStorageItem.getDescriptionId().contains("backpacked")) continue;
            InventoryAccessRecord record3 = new InventoryAccessRecord();
            record3.ItemChest = maybeStorageItem.copy();
            record3.ItemChest.remove(DataComponents.CONTAINER);
            record3.Nameable = true;
            record3.Name = record3.ItemChest.getHoverName();
            record3.Type = slotName;
            record3.VisibleSlotCount = container.getSlots() <= 27 ? 27 : 54;
            record3.ItemFirst = ItemStack.EMPTY;
            record3.Index = this.adjacentInventories.size();
            this.adjacentInventories.add(record3);
        }
        if (ModList.get().isLoaded("travelersbackpack") && TravelersBackpack.isPresent(player) && TravelersBackpack.slotCount(player) <= 54 && !(icon2 = TravelersBackpack.getTabIcon(player)).isEmpty()) {
            record = new InventoryAccessRecord();
            record.ItemChest = icon2;
            record.Nameable = true;
            record.Name = record.ItemChest.getHoverName();
            record.Type = "floating";
            record.VisibleSlotCount = TravelersBackpack.slotCount(player) <= 27 ? 27 : 54;
            record.ItemFirst = TravelersBackpack.getFirst(player);
            record.Index = this.adjacentInventories.size();
            record.ModId = "travelersbackpack";
            this.adjacentInventories.add(record);
        }
        if (ModList.get().isLoaded("backpacked") && BackpackedBackpack.isPresent(player) && BackpackedBackpack.slotCount(player) <= 54 && !(icon = BackpackedBackpack.getTabIcon(player)).isEmpty()) {
            record = new InventoryAccessRecord();
            record.ItemChest = icon;
            record.Nameable = true;
            record.Name = record.ItemChest.getHoverName();
            record.Type = "floating";
            record.VisibleSlotCount = BackpackedBackpack.slotCount(player) <= 27 ? 27 : 54;
            record.ItemFirst = BackpackedBackpack.getFirst(player);
            record.Index = this.adjacentInventories.size();
            record.ModId = "backpacked";
            this.adjacentInventories.add(record);
        }
    }

    private void loadAdjacentInventoriesCore(Level level, BlockPos pos, Player player, int range) {
        BlockPos.MutableBlockPos pos2 = new BlockPos.MutableBlockPos();
        for (int dy = 1; dy >= 0; --dy) {
            if (pos.getY() + dy > level.getMaxBuildHeight()) continue;
            for (int dx = -range; dx <= range; ++dx) {
                for (int dz = -range; dz <= range; ++dz) {
                    BaseContainerBlockEntity bcbe;
                    if (!this.isInRange(dx, dz, range)) continue;
                    pos2.set(pos.getX() + dx, pos.getY() + dy, pos.getZ() + dz);
                    BlockEntity be = level.getBlockEntity((BlockPos)pos2);
                    this.resolveBlockContainer(be, player, (BlockPos)pos2, level);
                    if (this.chosenContainer == null || be instanceof BaseContainerBlockEntity && !(bcbe = (BaseContainerBlockEntity)be).canOpen(player)) continue;
                    InventoryAccessRecord record = new InventoryAccessRecord();
                    record.ModId = "";
                    record.ItemChest = be.getBlockState().getBlock().asItem().getDefaultInstance();
                    if (record.ItemChest.isEmpty()) {
                        record.ItemChest = be.getBlockState().getCloneItemStack((HitResult)new BlockHitResult(pos2.getCenter(), Direction.UP, (BlockPos)pos2, false), (LevelReader)level, (BlockPos)pos2, player);
                        record.Name = record.ItemChest.getHoverName();
                        if (record.ItemChest.isEmpty()) {
                            record.ItemChest = Items.BARREL.getDefaultInstance();
                            record.Name = be.getBlockState().getBlock().getName();
                        }
                    }
                    if (record.Name == null) {
                        BlockEntity blockEntity = this.chosenContainerForRename;
                        if (blockEntity instanceof BaseContainerBlockEntity) {
                            BaseContainerBlockEntity bcbe2 = (BaseContainerBlockEntity)blockEntity;
                            record.Name = bcbe2.getName();
                            record.Nameable = true;
                        } else {
                            record.Name = record.ItemChest.getHoverName();
                            record.Nameable = false;
                        }
                    }
                    record.x = pos2.getX();
                    record.y = pos2.getY();
                    record.z = pos2.getZ();
                    record.Type = "block";
                    record.VisibleSlotCount = this.chosenContainerVisibleSize;
                    if (this.chestPrimaryPos != null) {
                        record.x = this.chestPrimaryPos.getX();
                        record.y = this.chestPrimaryPos.getY();
                        record.z = this.chestPrimaryPos.getZ();
                    }
                    record.ItemFirst = this.chosenContainer.getItem(0);
                    record.Index = this.adjacentInventories.size();
                    this.adjacentInventories.add(record);
                }
            }
        }
    }

    private boolean isInRange(int dx, int dz, int range) {
        if (dx == 0 && dz == 0) {
            return false;
        }
        return Math.abs(dx) + Math.abs(dz) <= range;
    }

    public void putInventoriesIntoAContainerForTransferToClient(Container tabElements, int max) {
        int i;
        if (this.adjacentInventories == null || this.adjacentInventories.size() == 0) {
            return;
        }
        max = Math.min(this.adjacentInventories.size(), max);
        for (i = 0; i < max; ++i) {
            InventoryAccessRecord current = this.adjacentInventories.get(i);
            ItemStack chest = current.ItemChest.copy();
            chest.set(DataComponents.CUSTOM_NAME, (Object)current.Name);
            int flags = 1;
            if (current.VisibleSlotCount > 27) {
                flags |= 2;
            }
            if (!current.Nameable) {
                flags |= 4;
            }
            chest.set((DataComponentType)Registration.TAB_FLAGS.get(), (Object)flags);
            ItemStack suff = current.ItemFirst.copy();
            tabElements.setItem(i * 2, chest);
            tabElements.setItem(i * 2 + 1, suff);
        }
        for (i = max * 2; i < tabElements.getContainerSize(); ++i) {
            if (tabElements.getItem(i).isEmpty()) continue;
            tabElements.setItem(i, ItemStack.EMPTY);
        }
    }

    public boolean tryInitializeInventoryAccess(Level level, Player player, int index) {
        this.chosenContainerTrueSize = 0;
        this.chosenContainer = null;
        this.chosenContainerItem = null;
        if (this.adjacentInventories == null || this.adjacentInventories.size() <= index) {
            return false;
        }
        InventoryAccessRecord record = this.adjacentInventories.get(index);
        if (record.Type.equals("block")) {
            BlockPos pos = new BlockPos(record.x, record.y, record.z);
            BlockEntity be = level.getBlockEntity(pos);
            this.resolveBlockContainer(be, player, pos, level);
            return this.chosenContainer != null;
        }
        if (record.Type.equals("belt")) {
            Container belt = TetraBeltSupport.getToolbeltStorage(player);
            if (belt == null) {
                return false;
            }
            this.chosenContainer = new SimpleTableMenu.VariableSizeContainerWrapper((Container)new TetraBeltTranslator(belt), false);
            this.chosenContainerTrueSize = belt.getContainerSize() / TetraBeltTranslator.GetRowWidth(belt) * 9;
            this.chosenContainerItem = (ItemStack)TetraBeltSupport.findToolbelt(player);
            this.currentType = "belt";
            return true;
        }
        if (record.Type.equals("leggings_item") || record.Type.equals("chest_item") || record.Type.equals("back_item")) {
            ItemStack item = InventoryAccessHelper.getItemFromNamedSlot(player, record.Type);
            IItemHandler itemHandler = (IItemHandler)item.getCapability(Capabilities.ItemHandler.ITEM, null);
            if (itemHandler != null) {
                this.chosenContainer = new SimpleTableMenu.VariableSizeItemStackHandlerWrapper(itemHandler, false);
                this.chosenContainerTrueSize = itemHandler.getSlots();
                this.chosenContainerItem = item;
                this.currentType = record.Type;
            } else {
                ItemContainerContents container = (ItemContainerContents)item.get(DataComponents.CONTAINER);
                if (container != null) {
                    this.chosenContainer = new ItemContainerContentsWrapper(container, item, container.getSlots());
                    this.chosenContainerTrueSize = container.getSlots();
                    this.chosenContainerVisibleSize = container.getSlots() <= 27 ? 27 : 54;
                    this.chosenContainerItem = item;
                    this.currentType = record.Type;
                }
            }
            return this.chosenContainerTrueSize > 0;
        }
        if (record.Type.equals("floating")) {
            if (ModList.get().isLoaded("travelersbackpack") && record.ModId.equals("travelersbackpack") && TravelersBackpack.isPresent(player) && TravelersBackpack.slotCount(player) <= 54) {
                this.chosenContainer = new SimpleTableMenu.VariableSizeItemStackHandlerWrapper(TravelersBackpack.getItems(player), false);
                this.chosenContainerTrueSize = TravelersBackpack.slotCount(player);
                this.chosenContainerItem = TravelersBackpack.getContainerItem(player);
                this.currentType = "floating";
                return true;
            }
            if (ModList.get().isLoaded("backpacked") && record.ModId.equals("backpacked") && BackpackedBackpack.isPresent(player)) {
                this.chosenContainer = new SimpleTableMenu.VariableSizeContainerWrapper(BackpackedBackpack.getContainer(player), false);
                this.chosenContainerTrueSize = BackpackedBackpack.slotCount(player);
                this.chosenContainerItem = BackpackedBackpack.getContainerItem(player);
                this.currentType = record.Type;
                return true;
            }
            return false;
        }
        return false;
    }

    public static ItemStack getItemFromNamedSlot(Player player, String slot) {
        if (slot.equals("leggings_item")) {
            return player.getInventory().getArmor(1);
        }
        if (slot.equals("chest_item")) {
            return player.getInventory().getArmor(2);
        }
        if (slot.equals("back_item")) {
            return BackpackAccessor.getFirstItemFromBackSlot(player);
        }
        return ItemStack.EMPTY;
    }

    private void sort(BlockPos pos, BlockPos posSecondary) {
        InventoryAccessRecord right;
        InventoryAccessRecord left;
        int k;
        int i;
        for (i = 0; i < this.adjacentInventories.size() - 1; ++i) {
            for (k = i + 1; k < this.adjacentInventories.size(); ++k) {
                left = this.adjacentInventories.get(i);
                right = this.adjacentInventories.get(k);
                if (!left.Type.equals("block") || !right.Type.equals("block") || left.x != right.x || left.y != right.y || left.z != right.z) continue;
                this.adjacentInventories.remove(k);
                --k;
            }
        }
        for (i = 0; i < this.adjacentInventories.size() - 1; ++i) {
            for (k = i + 1; k < this.adjacentInventories.size(); ++k) {
                left = this.adjacentInventories.get(i);
                right = this.adjacentInventories.get(k);
                if (right.Type.equals("block") || left.Type.equals("block")) {
                    if (!right.Type.equals("block") || left.Type.equals("block")) continue;
                    this.adjacentInventories.set(i, right);
                    this.adjacentInventories.set(k, left);
                    continue;
                }
                if (left.y < right.y) {
                    this.adjacentInventories.set(i, right);
                    this.adjacentInventories.set(k, left);
                    continue;
                }
                if (posSecondary == null || left.y != right.y) continue;
                if (pos.getX() == posSecondary.getX() && pos.getZ() < posSecondary.getZ()) {
                    if (left.z <= right.z) continue;
                    this.adjacentInventories.set(i, right);
                    this.adjacentInventories.set(k, left);
                    continue;
                }
                if (pos.getX() == posSecondary.getX() && pos.getZ() > posSecondary.getZ()) {
                    if (left.z >= right.z) continue;
                    this.adjacentInventories.set(i, right);
                    this.adjacentInventories.set(k, left);
                    continue;
                }
                if (pos.getZ() == posSecondary.getZ() && pos.getX() < posSecondary.getX()) {
                    if (left.x <= right.x) continue;
                    this.adjacentInventories.set(i, right);
                    this.adjacentInventories.set(k, left);
                    continue;
                }
                if (pos.getZ() != posSecondary.getZ() || pos.getX() <= posSecondary.getX() || left.x >= right.x) continue;
                this.adjacentInventories.set(i, right);
                this.adjacentInventories.set(k, left);
            }
        }
    }

    static class RecordTypes {
        public static final String BLOCK = "block";
        public static final String TOOLBELT = "belt";
        public static final String LEGGINGS = "leggings_item";
        public static final String CHESTSLOT = "chest_item";
        public static final String BACKSLOT = "back_item";
        public static final String FLOATING = "floating";
        public static final String[] NAMED_SLOTS = new String[]{"leggings_item", "chest_item", "back_item"};

        RecordTypes() {
        }
    }

    static class InventoryAccessRecord {
        public Component Name = null;
        public ItemStack ItemChest = ItemStack.EMPTY;
        public ItemStack ItemFirst = ItemStack.EMPTY;
        public int Index;
        public int x;
        public int y;
        public int z;
        public boolean Nameable = false;
        public String Type = "";
        public int VisibleSlotCount = 3;
        public String ModId = "";

        InventoryAccessRecord() {
        }
    }
}

